package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping getParamInput {
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf paramName {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/getParamInput</i>
 *
 */
public interface GetParamInput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "getParamInput").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>objId</code>, or <code>null</code> if not present
     */
    ObjId getObjId();
    
    /**
     * @return <code>java.lang.String</code> <code>paramName</code>, or <code>null</code> if not present
     */
    java.lang.String getParamName();

}

