package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping ocpHeader {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/ocpHeader</i>
 *
 */
public interface OcpHeader
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "ocpHeader").intern();

    /**
     * OCP message type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType</code> <code>msgType</code>, or <code>null</code> if not present
     */
    OcpMsgType getMsgType();
    
    /**
     * Transaction ID
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>xid</code>, or <code>null</code> if not present
     */
    java.lang.Long getXid();

}

