package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;


public enum OcpMsgType {
    HEALTHCHECKREQ(0, "HEALTHCHECKREQ"),
    
    HEALTHCHECKRESP(1, "HEALTHCHECKRESP"),
    
    SETTIMEREQ(2, "SETTIMEREQ"),
    
    SETTIMERESP(3, "SETTIMERESP"),
    
    RESETREQ(4, "RESETREQ"),
    
    RESETRESP(5, "RESETRESP"),
    
    GETPARAMREQ(6, "GETPARAMREQ"),
    
    GETPARAMRESP(7, "GETPARAMRESP"),
    
    MODIFYPARAMREQ(8, "MODIFYPARAMREQ"),
    
    MODIFYPARAMRESP(9, "MODIFYPARAMRESP"),
    
    CREATEOBJREQ(10, "CREATEOBJREQ"),
    
    CREATEOBJRESP(11, "CREATEOBJRESP"),
    
    DELETEOBJREQ(12, "DELETEOBJREQ"),
    
    DELETEOBJRESP(13, "DELETEOBJRESP"),
    
    GETSTATEREQ(14, "GETSTATEREQ"),
    
    GETSTATERESP(15, "GETSTATERESP"),
    
    STATECHANGEIND(16, "STATECHANGEIND"),
    
    MODIFYSTATEREQ(17, "MODIFYSTATEREQ"),
    
    MODIFYSTATERESP(18, "MODIFYSTATERESP"),
    
    GETFAULTREQ(19, "GETFAULTREQ"),
    
    GETFAULTRESP(20, "GETFAULTRESP"),
    
    FAULTIND(21, "FAULTIND"),
    
    HELLOACK(22, "HELLOACK"),
    
    HELLOIND(23, "HELLOIND"),
    
    REDIRECTREQ(24, "REDIRECTREQ"),
    
    REDIRECTRESP(25, "REDIRECTRESP")
    ;


    java.lang.String name;
    int value;
    private static final java.util.Map<java.lang.Integer, OcpMsgType> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, OcpMsgType> b = com.google.common.collect.ImmutableMap.builder();
        for (OcpMsgType enumItem : OcpMsgType.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private OcpMsgType(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding OcpMsgType item
     */
    public static OcpMsgType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
