package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping stateChangeInd {
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf stateType {
 *         type StateType;
 *     }
 *     leaf stateValue {
 *         type StateVal;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/stateChangeInd</i>
 *
 */
public interface StateChangeInd
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "stateChangeInd").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>objId</code>, or <code>null</code> if not present
     */
    ObjId getObjId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateType</code> <code>stateType</code>, or <code>null</code> if not present
     */
    StateType getStateType();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateVal</code> <code>stateValue</code>, or <code>null</code> if not present
     */
    StateVal getStateValue();

}

