package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;


public enum StateVal {
    LOCKED(0, "LOCKED"),
    
    UNLOCKED(1, "UNLOCKED"),
    
    PREOPERATIONAL(2, "PRE_OPERATIONAL"),
    
    OPERATIONAL(3, "OPERATIONAL"),
    
    DEGRADED(4, "DEGRADED"),
    
    FAILED(5, "FAILED"),
    
    NOTOPERATIONAL(6, "NOT_OPERATIONAL"),
    
    DISABLED(7, "DISABLED")
    ;


    java.lang.String name;
    int value;
    private static final java.util.Map<java.lang.Integer, StateVal> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, StateVal> b = com.google.common.collect.ImmutableMap.builder();
        for (StateVal enumItem : StateVal.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private StateVal(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding StateVal item
     */
    public static StateVal forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
