package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetFaultOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.Fault;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * list obj {
 *     key "id"
 *     leaf id {
 *         type ObjId;
 *     }
 *     list fault {
 *         key "id"
 *         leaf id {
 *             type FaultId;
 *         }
 *         leaf severity {
 *             type FaultSeverity;
 *         }
 *         leaf timestamp {
 *             type xsd-dateTime;
 *         }
 *         leaf descr {
 *             type string;
 *         }
 *         leaf-list affectedObj {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/getFaultOutput/obj</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.ObjBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.ObjBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.ObjKey
 *
 */
public interface Obj
    extends
    ChildOf<GetFaultOutput>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.Obj>,
    Identifiable<ObjKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "obj").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>id</code>, or <code>null</code> if not present
     */
    ObjId getId();
    
    /**
     * @return <code>java.util.List</code> <code>fault</code>, or <code>null</code> if not present
     */
    List<Fault> getFault();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.ObjKey</code> <code>key</code>, or <code>null</code> if not present
     */
    ObjKey getKey();

}

