package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.Obj;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * list fault {
 *     key "id"
 *     leaf id {
 *         type FaultId;
 *     }
 *     leaf severity {
 *         type FaultSeverity;
 *     }
 *     leaf timestamp {
 *         type xsd-dateTime;
 *     }
 *     leaf descr {
 *         type string;
 *     }
 *     leaf-list affectedObj {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/getFaultOutput/obj/fault</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.FaultBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.FaultBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.FaultKey
 *
 */
public interface Fault
    extends
    ChildOf<Obj>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.Fault>,
    Identifiable<FaultKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "fault").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId</code> <code>id</code>, or <code>null</code> if not present
     */
    FaultId getId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity</code> <code>severity</code>, or <code>null</code> if not present
     */
    FaultSeverity getSeverity();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime</code> <code>timestamp</code>, or <code>null</code> if not present
     */
    XsdDateTime getTimestamp();
    
    /**
     * @return <code>java.lang.String</code> <code>descr</code>, or <code>null</code> if not present
     */
    java.lang.String getDescr();
    
    /**
     * @return <code>java.util.List</code> <code>affectedObj</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getAffectedObj();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.FaultKey</code> <code>key</code>, or <code>null</code> if not present
     */
    FaultKey getKey();

}

