package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.obj.State;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateOutput;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * list obj {
 *     key "id"
 *     leaf id {
 *         type ObjId;
 *     }
 *     list state {
 *         key "type"
 *         leaf type {
 *             type StateType;
 *         }
 *         leaf value {
 *             type StateVal;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/getStateOutput/obj</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.ObjBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.ObjBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.ObjKey
 *
 */
public interface Obj
    extends
    ChildOf<GetStateOutput>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.Obj>,
    Identifiable<ObjKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "obj").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>id</code>, or <code>null</code> if not present
     */
    ObjId getId();
    
    /**
     * @return <code>java.util.List</code> <code>state</code>, or <code>null</code> if not present
     */
    List<State> getState();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.ObjKey</code> <code>key</code>, or <code>null</code> if not present
     */
    ObjKey getKey();

}

