package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811;


public enum TransportProtocol {
    /**
     * Communication over TCP protocol.
     *
     */
    TCP(0, "TCP"),
    
    /**
     * Communication over TLS protocol.
     *
     */
    TLS(1, "TLS"),
    
    /**
     * Communication over UDP protocol.
     *
     */
    UDP(2, "UDP")
    ;


    java.lang.String name;
    int value;
    private static final java.util.Map<java.lang.Integer, TransportProtocol> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, TransportProtocol> b = com.google.common.collect.ImmutableMap.builder();
        for (TransportProtocol enumItem : TransportProtocol.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private TransportProtocol(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding TransportProtocol item
     */
    public static TransportProtocol forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
