package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-extension</b>
 * <pre>
 * notification hello-message {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf version {
 *         type string;
 *     }
 *     leaf vendorId {
 *         type string;
 *     }
 *     leaf serialNumber {
 *         type string;
 *     }
 *     uses helloInd;
 *     uses ocpHeader;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-extension/hello-message</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessageBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessageBuilder
 *
 */
public interface HelloMessage
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>,
    HelloInd,
    OcpHeader,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:extension",
        "2015-08-11", "hello-message").intern();


}

