package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage
 *
 */
public class HelloMessageBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage> {

    private OcpMsgType _msgType;
    private java.lang.String _serialNumber;
    private java.lang.String _vendorId;
    private java.lang.String _version;
    private java.lang.Long _xid;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> augmentation = Collections.emptyMap();

    public HelloMessageBuilder() {
    }
    public HelloMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd arg) {
        this._version = arg.getVersion();
        this._vendorId = arg.getVendorId();
        this._serialNumber = arg.getSerialNumber();
    }
    public HelloMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public HelloMessageBuilder(HelloMessage base) {
        this._msgType = base.getMsgType();
        this._serialNumber = base.getSerialNumber();
        this._vendorId = base.getVendorId();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof HelloMessageImpl) {
            HelloMessageImpl impl = (HelloMessageImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd) {
            this._version = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd)arg).getVersion();
            this._vendorId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd)arg).getVendorId();
            this._serialNumber = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd)arg).getSerialNumber();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader) {
            this._msgType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader)arg).getMsgType();
            this._xid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public OcpMsgType getMsgType() {
        return _msgType;
    }
    
    public java.lang.String getSerialNumber() {
        return _serialNumber;
    }
    
    public java.lang.String getVendorId() {
        return _vendorId;
    }
    
    public java.lang.String getVersion() {
        return _version;
    }
    
    public java.lang.Long getXid() {
        return _xid;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public HelloMessageBuilder setMsgType(final OcpMsgType value) {
        this._msgType = value;
        return this;
    }
    
     
    public HelloMessageBuilder setSerialNumber(final java.lang.String value) {
        this._serialNumber = value;
        return this;
    }
    
     
    public HelloMessageBuilder setVendorId(final java.lang.String value) {
        this._vendorId = value;
        return this;
    }
    
     
    public HelloMessageBuilder setVersion(final java.lang.String value) {
        this._version = value;
        return this;
    }
    
     
     private static void checkXidRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public HelloMessageBuilder setXid(final java.lang.Long value) {
    if (value != null) {
        checkXidRange(value);
    }
        this._xid = value;
        return this;
    }
    
    public HelloMessageBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public HelloMessageBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public HelloMessage build() {
        return new HelloMessageImpl(this);
    }

    private static final class HelloMessageImpl implements HelloMessage {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage.class;
        }

        private final OcpMsgType _msgType;
        private final java.lang.String _serialNumber;
        private final java.lang.String _vendorId;
        private final java.lang.String _version;
        private final java.lang.Long _xid;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> augmentation = Collections.emptyMap();

        private HelloMessageImpl(HelloMessageBuilder base) {
            this._msgType = base.getMsgType();
            this._serialNumber = base.getSerialNumber();
            this._vendorId = base.getVendorId();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return _msgType;
        }
        
        @Override
        public java.lang.String getSerialNumber() {
            return _serialNumber;
        }
        
        @Override
        public java.lang.String getVendorId() {
            return _vendorId;
        }
        
        @Override
        public java.lang.String getVersion() {
            return _version;
        }
        
        @Override
        public java.lang.Long getXid() {
            return _xid;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_msgType);
            result = prime * result + Objects.hashCode(_serialNumber);
            result = prime * result + Objects.hashCode(_vendorId);
            result = prime * result + Objects.hashCode(_version);
            result = prime * result + Objects.hashCode(_xid);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage other = (org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage)obj;
            if (!Objects.equals(_msgType, other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(_serialNumber, other.getSerialNumber())) {
                return false;
            }
            if (!Objects.equals(_vendorId, other.getVendorId())) {
                return false;
            }
            if (!Objects.equals(_version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(_xid, other.getXid())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                HelloMessageImpl otherImpl = (HelloMessageImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "HelloMessage [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_msgType != null) {
                builder.append("_msgType=");
                builder.append(_msgType);
                builder.append(", ");
            }
            if (_serialNumber != null) {
                builder.append("_serialNumber=");
                builder.append(_serialNumber);
                builder.append(", ");
            }
            if (_vendorId != null) {
                builder.append("_vendorId=");
                builder.append(_vendorId);
                builder.append(", ");
            }
            if (_version != null) {
                builder.append("_version=");
                builder.append(_version);
                builder.append(", ");
            }
            if (_xid != null) {
                builder.append("_xid=");
                builder.append(_xid);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
