package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput
 *
 */
public class ReDirectInputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput> {

    private Ipv4Address _ip;
    private OcpMsgType _msgType;
    private java.lang.Long _xid;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> augmentation = Collections.emptyMap();

    public ReDirectInputBuilder() {
    }
    public ReDirectInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput arg) {
        this._ip = arg.getIp();
    }
    public ReDirectInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public ReDirectInputBuilder(ReDirectInput base) {
        this._ip = base.getIp();
        this._msgType = base.getMsgType();
        this._xid = base.getXid();
        if (base instanceof ReDirectInputImpl) {
            ReDirectInputImpl impl = (ReDirectInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader) {
            this._msgType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader)arg).getMsgType();
            this._xid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput) {
            this._ip = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput)arg).getIp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput] \n" +
              "but was: " + arg
            );
        }
    }

    public Ipv4Address getIp() {
        return _ip;
    }
    
    public OcpMsgType getMsgType() {
        return _msgType;
    }
    
    public java.lang.Long getXid() {
        return _xid;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ReDirectInputBuilder setIp(final Ipv4Address value) {
        this._ip = value;
        return this;
    }
    
     
    public ReDirectInputBuilder setMsgType(final OcpMsgType value) {
        this._msgType = value;
        return this;
    }
    
     
     private static void checkXidRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public ReDirectInputBuilder setXid(final java.lang.Long value) {
    if (value != null) {
        checkXidRange(value);
    }
        this._xid = value;
        return this;
    }
    
    public ReDirectInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ReDirectInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ReDirectInput build() {
        return new ReDirectInputImpl(this);
    }

    private static final class ReDirectInputImpl implements ReDirectInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput.class;
        }

        private final Ipv4Address _ip;
        private final OcpMsgType _msgType;
        private final java.lang.Long _xid;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> augmentation = Collections.emptyMap();

        private ReDirectInputImpl(ReDirectInputBuilder base) {
            this._ip = base.getIp();
            this._msgType = base.getMsgType();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ipv4Address getIp() {
            return _ip;
        }
        
        @Override
        public OcpMsgType getMsgType() {
            return _msgType;
        }
        
        @Override
        public java.lang.Long getXid() {
            return _xid;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ip);
            result = prime * result + Objects.hashCode(_msgType);
            result = prime * result + Objects.hashCode(_xid);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput)obj;
            if (!Objects.equals(_ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals(_msgType, other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(_xid, other.getXid())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ReDirectInputImpl otherImpl = (ReDirectInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "ReDirectInput [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_ip != null) {
                builder.append("_ip=");
                builder.append(_ip);
                builder.append(", ");
            }
            if (_msgType != null) {
                builder.append("_msgType=");
                builder.append(_msgType);
                builder.append(", ");
            }
            if (_xid != null) {
                builder.append("_xid=");
                builder.append(_xid);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
