package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-extension</b>
 * <pre>
 * container output {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf result {
 *         type string;
 *     }
 *     uses ocpHeader;
 *     uses redirectOutput;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-extension/re-direct/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectOutputBuilder
 *
 */
public interface ReDirectOutput
    extends
    OcpHeader,
    RedirectOutput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:extension",
        "2015-08-11", "output").intern();


}

