package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-protocol</b>
 * <pre>
 * container input {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf paramName {
 *         type string;
 *     }
 *     uses getParamInput;
 *     uses ocpHeader;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-protocol/get-param/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInputBuilder
 *
 */
public interface GetParamInput
    extends
    org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamInput,
    OcpHeader,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:protocol",
        "2015-08-11", "input").intern();


}

