package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-protocol</b>
 * <pre>
 * container input {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf stateType {
 *         type StateAllType;
 *     }
 *     leaf eventDrivenReporting {
 *         type boolean;
 *     }
 *     uses getStateInput;
 *     uses ocpHeader;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-protocol/get-state/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateInputBuilder
 *
 */
public interface GetStateInput
    extends
    org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput,
    OcpHeader,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:protocol",
        "2015-08-11", "input").intern();


}

