package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;
import org.opendaylight.yangtools.yang.binding.NotificationListener;


/**
 * Interface for receiving the following YANG notifications defined in module <b>ocp-protocol</b>
 * <pre>
 * notification state-change-ind {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf stateType {
 *         type StateType;
 *     }
 *     leaf stateValue {
 *         type StateVal;
 *     }
 *     uses stateChangeInd;
 *     uses ocpHeader;
 * }
 * notification fault-ind {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf faultId {
 *         type FaultId;
 *     }
 *     leaf state {
 *         type FaultState;
 *     }
 *     leaf severity {
 *         type FaultSeverity;
 *     }
 *     leaf timestamp {
 *         type xsd-dateTime;
 *     }
 *     leaf descr {
 *         type string;
 *     }
 *     leaf-list affectedObj {
 *         type string;
 *     }
 *     uses faultInd;
 *     uses ocpHeader;
 * }
 * </pre>
 *
 */
public interface OcpProtocolListener
    extends
    NotificationListener
{




    void onStateChangeInd(StateChangeInd notification);
    
    void onFaultInd(FaultInd notification);

}

