package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.binding.RpcService;
import java.util.concurrent.Future;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>ocp-protocol</b>
 * <pre>
 * rpc get-state {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         leaf stateType {
 *             type StateAllType;
 *         }
 *         leaf eventDrivenReporting {
 *             type boolean;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type GetStateRes;
 *         }
 *         list obj {
 *             key "id"
 *             leaf id {
 *                 type ObjId;
 *             }
 *             list state {
 *                 key "type"
 *                 leaf type {
 *                     type StateType;
 *                 }
 *                 leaf value {
 *                     type StateVal;
 *                 }
 *             }
 *         }
 *     }
 * }
 * rpc re-reset {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type OriRes;
 *         }
 *     }
 * }
 * rpc set-time {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf newTime {
 *             type xsd-dateTime;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type OriRes;
 *         }
 *     }
 * }
 * rpc modify-param {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         list param {
 *             key "name"
 *             leaf name {
 *                 type string;
 *             }
 *             leaf value {
 *                 type string;
 *             }
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf globResult {
 *             type ModifyParamGlobRes;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         list param {
 *             key "name"
 *             leaf name {
 *                 type string;
 *             }
 *             leaf result {
 *                 type ModifyParamRes;
 *             }
 *         }
 *     }
 * }
 * rpc health-check {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf tcpLinkMonTimeout {
 *             type xsd-unsignedShort;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type OriRes;
 *         }
 *     }
 * }
 * rpc get-param {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         leaf paramName {
 *             type string;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type GetParamRes;
 *         }
 *         list obj {
 *             key "id"
 *             leaf id {
 *                 type ObjId;
 *             }
 *             list param {
 *                 key "name"
 *                 leaf name {
 *                     type string;
 *                 }
 *                 leaf value {
 *                     type string;
 *                 }
 *             }
 *         }
 *     }
 * }
 * rpc create-obj {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf objType {
 *             type ObjType;
 *         }
 *         list param {
 *             key "name"
 *             leaf name {
 *                 type string;
 *             }
 *             leaf value {
 *                 type string;
 *             }
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf globResult {
 *             type CreateObjGlobRes;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         list param {
 *             key "name"
 *             leaf name {
 *                 type string;
 *             }
 *             leaf result {
 *                 type CreateObjRes;
 *             }
 *         }
 *     }
 * }
 * rpc delete-obj {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf obj-id {
 *             type ObjId;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type DeleteObjRes;
 *         }
 *     }
 * }
 * rpc modify-state {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         leaf stateType {
 *             type StateType;
 *         }
 *         leaf stateValue {
 *             type StateVal;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type ModifyStateRes;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         leaf stateType {
 *             type StateType;
 *         }
 *         leaf stateValue {
 *             type StateVal;
 *         }
 *     }
 * }
 * rpc get-fault {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf objId {
 *             type ObjId;
 *         }
 *         leaf eventDrivenReporting {
 *             type boolean;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type GetFaultRes;
 *         }
 *         list obj {
 *             key "id"
 *             leaf id {
 *                 type ObjId;
 *             }
 *             list fault {
 *                 key "id"
 *                 leaf id {
 *                     type FaultId;
 *                 }
 *                 leaf severity {
 *                     type FaultSeverity;
 *                 }
 *                 leaf timestamp {
 *                     type xsd-dateTime;
 *                 }
 *                 leaf descr {
 *                     type string;
 *                 }
 *                 leaf-list affectedObj {
 *                     type string;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface OcpProtocolService
    extends
    RpcService
{




    /**
     * @return <code>java.util.concurrent.Future</code> <code>state</code>, or <code>null</code> if not present
     */
    Future<RpcResult<GetStateOutput>> getState(GetStateInput input);
    
    Future<RpcResult<ReResetOutput>> reReset(ReResetInput input);
    
    Future<RpcResult<SetTimeOutput>> setTime(SetTimeInput input);
    
    Future<RpcResult<ModifyParamOutput>> modifyParam(ModifyParamInput input);
    
    Future<RpcResult<HealthCheckOutput>> healthCheck(HealthCheckInput input);
    
    /**
     * @return <code>java.util.concurrent.Future</code> <code>param</code>, or <code>null</code> if not present
     */
    Future<RpcResult<GetParamOutput>> getParam(GetParamInput input);
    
    Future<RpcResult<CreateObjOutput>> createObj(CreateObjInput input);
    
    Future<RpcResult<DeleteObjOutput>> deleteObj(DeleteObjInput input);
    
    Future<RpcResult<ModifyStateOutput>> modifyState(ModifyStateInput input);
    
    /**
     * @return <code>java.util.concurrent.Future</code> <code>fault</code>, or <code>null</code> if not present
     */
    Future<RpcResult<GetFaultOutput>> getFault(GetFaultInput input);

}

