package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;


/**
 * Radiohead-idle notification
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>system-notifications</b>
 * <pre>
 * notification radioHead-idle-event {
 *     description
 *         "Radiohead-idle notification";
 *     leaf info {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>system-notifications/radioHead-idle-event</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.RadioHeadIdleEventBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.RadioHeadIdleEventBuilder
 *
 */
public interface RadioHeadIdleEvent
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811.RadioHeadIdleEvent>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:system",
        "2015-08-11", "radioHead-idle-event").intern();

    /**
     * @return <code>java.lang.String</code> <code>info</code>, or <code>null</code> if not present
     */
    java.lang.String getInfo();

}

