package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.system.rev150811;
import org.opendaylight.yangtools.yang.binding.NotificationListener;


/**
 * Interface for receiving the following YANG notifications defined in module <b>system-notifications</b>
 * <pre>
 * notification disconnect-event {
 *     description
 *         "Disconnect notification";
 *     leaf info {
 *         type string;
 *     }
 * }
 * notification radioHead-idle-event {
 *     description
 *         "Radiohead-idle notification";
 *     leaf info {
 *         type string;
 *     }
 * }
 * </pre>
 *
 */
public interface SystemNotificationsListener
    extends
    NotificationListener
{




    /**
     * Disconnect notification
     *
     */
    void onDisconnectEvent(DisconnectEvent notification);
    
    /**
     * Radiohead-idle notification
     *
     */
    void onRadioHeadIdleEvent(RadioHeadIdleEvent notification);

}

