package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import com.google.common.io.BaseEncoding;


/**
 * XSD hex binary encoded string
 *
 */
public class XsdHexBinary
 implements Serializable {
    private static final long serialVersionUID = 2477011696808633001L;
    private final byte[] _value;


    @ConstructorProperties("value")
    public XsdHexBinary(byte[] _value) {
    
    
        Preconditions.checkNotNull(_value, "Supplied value may not be null");
    
    
        this._value = _value.clone();
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public XsdHexBinary(XsdHexBinary source) {
        this._value = source._value;
    }

    public static XsdHexBinary getDefaultInstance(String defaultValue) {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        return new XsdHexBinary(baseEncoding.decode(defaultValue));
    }

    public byte[] getValue() {
        return _value == null ? null : _value.clone();
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(_value);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        XsdHexBinary other = (XsdHexBinary) obj;
        if (!Arrays.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdHexBinary.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(Arrays.toString(_value));
         }
        return builder.append(']').toString();
    }
}

