/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum OcpMsgType {
    HEALTHCHECKREQ(0, "HEALTHCHECKREQ"),
    HEALTHCHECKRESP(1, "HEALTHCHECKRESP"),
    SETTIMEREQ(2, "SETTIMEREQ"),
    SETTIMERESP(3, "SETTIMERESP"),
    RESETREQ(4, "RESETREQ"),
    RESETRESP(5, "RESETRESP"),
    GETPARAMREQ(6, "GETPARAMREQ"),
    GETPARAMRESP(7, "GETPARAMRESP"),
    MODIFYPARAMREQ(8, "MODIFYPARAMREQ"),
    MODIFYPARAMRESP(9, "MODIFYPARAMRESP"),
    CREATEOBJREQ(10, "CREATEOBJREQ"),
    CREATEOBJRESP(11, "CREATEOBJRESP"),
    DELETEOBJREQ(12, "DELETEOBJREQ"),
    DELETEOBJRESP(13, "DELETEOBJRESP"),
    GETSTATEREQ(14, "GETSTATEREQ"),
    GETSTATERESP(15, "GETSTATERESP"),
    STATECHANGEIND(16, "STATECHANGEIND"),
    MODIFYSTATEREQ(17, "MODIFYSTATEREQ"),
    MODIFYSTATERESP(18, "MODIFYSTATERESP"),
    GETFAULTREQ(19, "GETFAULTREQ"),
    GETFAULTRESP(20, "GETFAULTRESP"),
    FAULTIND(21, "FAULTIND"),
    HELLOACK(22, "HELLOACK"),
    HELLOIND(23, "HELLOIND"),
    REDIRECTREQ(24, "REDIRECTREQ"),
    REDIRECTRESP(25, "REDIRECTRESP");

    String name;
    int value;
    private static final Map<Integer, OcpMsgType> VALUE_MAP;

    private OcpMsgType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static OcpMsgType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (OcpMsgType enumItem : OcpMsgType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

