/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.Obj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.ObjKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.Fault;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ObjBuilder
implements Builder<Obj> {
    private List<Fault> _fault;
    private ObjId _id;
    private ObjKey _key;
    Map<Class<? extends Augmentation<Obj>>, Augmentation<Obj>> augmentation = Collections.emptyMap();

    public ObjBuilder() {
    }

    public ObjBuilder(Obj base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ObjKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._fault = base.getFault();
        if (base instanceof ObjImpl) {
            ObjImpl impl = (ObjImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Obj>>, Augmentation<Obj>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Obj>>, Augmentation<Obj>>(casted.augmentations());
        }
    }

    public List<Fault> getFault() {
        return this._fault;
    }

    public ObjId getId() {
        return this._id;
    }

    public ObjKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Obj>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ObjBuilder setFault(List<Fault> value) {
        this._fault = value;
        return this;
    }

    public ObjBuilder setId(ObjId value) {
        this._id = value;
        return this;
    }

    public ObjBuilder setKey(ObjKey value) {
        this._key = value;
        return this;
    }

    public ObjBuilder addAugmentation(Class<? extends Augmentation<Obj>> augmentationType, Augmentation<Obj> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Obj>>, Augmentation<Obj>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ObjBuilder removeAugmentation(Class<? extends Augmentation<Obj>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Obj build() {
        return new ObjImpl(this);
    }

    private static final class ObjImpl
    implements Obj {
        private final List<Fault> _fault;
        private final ObjId _id;
        private final ObjKey _key;
        private Map<Class<? extends Augmentation<Obj>>, Augmentation<Obj>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Obj> getImplementedInterface() {
            return Obj.class;
        }

        private ObjImpl(ObjBuilder base) {
            if (base.getKey() == null) {
                this._key = new ObjKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._fault = base.getFault();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Obj>>, Augmentation<Obj>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Obj>>, Augmentation<Obj>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Fault> getFault() {
            return this._fault;
        }

        @Override
        public ObjId getId() {
            return this._id;
        }

        @Override
        public ObjKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Obj>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._fault);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Obj.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Obj other = (Obj)obj;
            if (!Objects.equals(this._fault, other.getFault())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ObjImpl otherImpl = (ObjImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Obj>>, Augmentation<Obj>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Obj [";
            StringBuilder builder = new StringBuilder(name);
            if (this._fault != null) {
                builder.append("_fault=");
                builder.append(this._fault);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

