/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.Fault;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getfaultoutput.obj.FaultKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FaultBuilder
implements Builder<Fault> {
    private List<String> _affectedObj;
    private String _descr;
    private FaultId _id;
    private FaultKey _key;
    private FaultSeverity _severity;
    private XsdDateTime _timestamp;
    Map<Class<? extends Augmentation<Fault>>, Augmentation<Fault>> augmentation = Collections.emptyMap();

    public FaultBuilder() {
    }

    public FaultBuilder(Fault base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new FaultKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._affectedObj = base.getAffectedObj();
        this._descr = base.getDescr();
        this._severity = base.getSeverity();
        this._timestamp = base.getTimestamp();
        if (base instanceof FaultImpl) {
            FaultImpl impl = (FaultImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Fault>>, Augmentation<Fault>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Fault>>, Augmentation<Fault>>(casted.augmentations());
        }
    }

    public List<String> getAffectedObj() {
        return this._affectedObj;
    }

    public String getDescr() {
        return this._descr;
    }

    public FaultId getId() {
        return this._id;
    }

    public FaultKey getKey() {
        return this._key;
    }

    public FaultSeverity getSeverity() {
        return this._severity;
    }

    public XsdDateTime getTimestamp() {
        return this._timestamp;
    }

    public <E extends Augmentation<Fault>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FaultBuilder setAffectedObj(List<String> value) {
        this._affectedObj = value;
        return this;
    }

    public FaultBuilder setDescr(String value) {
        this._descr = value;
        return this;
    }

    public FaultBuilder setId(FaultId value) {
        this._id = value;
        return this;
    }

    public FaultBuilder setKey(FaultKey value) {
        this._key = value;
        return this;
    }

    public FaultBuilder setSeverity(FaultSeverity value) {
        this._severity = value;
        return this;
    }

    public FaultBuilder setTimestamp(XsdDateTime value) {
        this._timestamp = value;
        return this;
    }

    public FaultBuilder addAugmentation(Class<? extends Augmentation<Fault>> augmentationType, Augmentation<Fault> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Fault>>, Augmentation<Fault>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FaultBuilder removeAugmentation(Class<? extends Augmentation<Fault>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Fault build() {
        return new FaultImpl(this);
    }

    private static final class FaultImpl
    implements Fault {
        private final List<String> _affectedObj;
        private final String _descr;
        private final FaultId _id;
        private final FaultKey _key;
        private final FaultSeverity _severity;
        private final XsdDateTime _timestamp;
        private Map<Class<? extends Augmentation<Fault>>, Augmentation<Fault>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Fault> getImplementedInterface() {
            return Fault.class;
        }

        private FaultImpl(FaultBuilder base) {
            if (base.getKey() == null) {
                this._key = new FaultKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._affectedObj = base.getAffectedObj();
            this._descr = base.getDescr();
            this._severity = base.getSeverity();
            this._timestamp = base.getTimestamp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Fault>>, Augmentation<Fault>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Fault>>, Augmentation<Fault>>(base.augmentation);
                }
            }
        }

        @Override
        public List<String> getAffectedObj() {
            return this._affectedObj;
        }

        @Override
        public String getDescr() {
            return this._descr;
        }

        @Override
        public FaultId getId() {
            return this._id;
        }

        @Override
        public FaultKey getKey() {
            return this._key;
        }

        @Override
        public FaultSeverity getSeverity() {
            return this._severity;
        }

        @Override
        public XsdDateTime getTimestamp() {
            return this._timestamp;
        }

        public <E extends Augmentation<Fault>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._affectedObj);
            result = 31 * result + Objects.hashCode(this._descr);
            result = 31 * result + Objects.hashCode((Object)this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode((Object)this._severity);
            result = 31 * result + Objects.hashCode(this._timestamp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Fault.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Fault other = (Fault)obj;
            if (!Objects.equals(this._affectedObj, other.getAffectedObj())) {
                return false;
            }
            if (!Objects.equals(this._descr, other.getDescr())) {
                return false;
            }
            if (!Objects.equals((Object)this._id, (Object)other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals((Object)this._severity, (Object)other.getSeverity())) {
                return false;
            }
            if (!Objects.equals(this._timestamp, other.getTimestamp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FaultImpl otherImpl = (FaultImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Fault>>, Augmentation<Fault>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Fault [";
            StringBuilder builder = new StringBuilder(name);
            if (this._affectedObj != null) {
                builder.append("_affectedObj=");
                builder.append(this._affectedObj);
                builder.append(", ");
            }
            if (this._descr != null) {
                builder.append("_descr=");
                builder.append(this._descr);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append((Object)this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._severity != null) {
                builder.append("_severity=");
                builder.append((Object)this._severity);
                builder.append(", ");
            }
            if (this._timestamp != null) {
                builder.append("_timestamp=");
                builder.append(this._timestamp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

