/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum KeystoreType {
    JKS(0, "JKS"),
    PKCS12(1, "PKCS12");

    String name;
    int value;
    private static final Map<Integer, KeystoreType> VALUE_MAP;

    private KeystoreType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static KeystoreType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (KeystoreType enumItem : KeystoreType.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

