/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class HelloMessageBuilder
implements Builder<HelloMessage> {
    private OcpMsgType _msgType;
    private String _serialNumber;
    private String _vendorId;
    private String _version;
    private Long _xid;
    Map<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>> augmentation = Collections.emptyMap();

    public HelloMessageBuilder() {
    }

    public HelloMessageBuilder(HelloInd arg) {
        this._version = arg.getVersion();
        this._vendorId = arg.getVendorId();
        this._serialNumber = arg.getSerialNumber();
    }

    public HelloMessageBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public HelloMessageBuilder(HelloMessage base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._serialNumber = base.getSerialNumber();
        this._vendorId = base.getVendorId();
        this._version = base.getVersion();
        this._xid = base.getXid();
        if (base instanceof HelloMessageImpl) {
            HelloMessageImpl impl = (HelloMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof HelloInd) {
            this._version = ((HelloInd)arg).getVersion();
            this._vendorId = ((HelloInd)arg).getVendorId();
            this._serialNumber = ((HelloInd)arg).getSerialNumber();
            isValidArg = true;
        }
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.HelloInd, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public String getVendorId() {
        return this._vendorId;
    }

    public String getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<HelloMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public HelloMessageBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public HelloMessageBuilder setSerialNumber(String value) {
        this._serialNumber = value;
        return this;
    }

    public HelloMessageBuilder setVendorId(String value) {
        this._vendorId = value;
        return this;
    }

    public HelloMessageBuilder setVersion(String value) {
        this._version = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public HelloMessageBuilder setXid(Long value) {
        if (value != null) {
            HelloMessageBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public HelloMessageBuilder addAugmentation(Class<? extends Augmentation<HelloMessage>> augmentationType, Augmentation<HelloMessage> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public HelloMessageBuilder removeAugmentation(Class<? extends Augmentation<HelloMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public HelloMessage build() {
        return new HelloMessageImpl(this);
    }

    private static final class HelloMessageImpl
    implements HelloMessage {
        private final OcpMsgType _msgType;
        private final String _serialNumber;
        private final String _vendorId;
        private final String _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<HelloMessage> getImplementedInterface() {
            return HelloMessage.class;
        }

        private HelloMessageImpl(HelloMessageBuilder base) {
            this._msgType = base.getMsgType();
            this._serialNumber = base.getSerialNumber();
            this._vendorId = base.getVendorId();
            this._version = base.getVersion();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public String getSerialNumber() {
            return this._serialNumber;
        }

        @Override
        public String getVendorId() {
            return this._vendorId;
        }

        @Override
        public String getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<HelloMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._serialNumber);
            result = 31 * result + Objects.hashCode(this._vendorId);
            result = 31 * result + Objects.hashCode(this._version);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!HelloMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            HelloMessage other = (HelloMessage)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._serialNumber, other.getSerialNumber())) {
                return false;
            }
            if (!Objects.equals(this._vendorId, other.getVendorId())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                HelloMessageImpl otherImpl = (HelloMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<HelloMessage>>, Augmentation<HelloMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "HelloMessage [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._serialNumber != null) {
                builder.append("_serialNumber=");
                builder.append(this._serialNumber);
                builder.append(", ");
            }
            if (this._vendorId != null) {
                builder.append("_vendorId=");
                builder.append(this._vendorId);
                builder.append(", ");
            }
            if (this._version != null) {
                builder.append("_version=");
                builder.append(this._version);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

