/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjGlobRes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.createobjoutput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.CreateObjOutput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CreateObjOutputBuilder
implements Builder<CreateObjOutput> {
    private CreateObjGlobRes _globResult;
    private OcpMsgType _msgType;
    private ObjId _objId;
    private List<Param> _param;
    private Long _xid;
    Map<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>> augmentation = Collections.emptyMap();

    public CreateObjOutputBuilder() {
    }

    public CreateObjOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjOutput arg) {
        this._objId = arg.getObjId();
        this._param = arg.getParam();
    }

    public CreateObjOutputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public CreateObjOutputBuilder(CreateObjOutput base) {
        AugmentationHolder casted;
        this._globResult = base.getGlobResult();
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._param = base.getParam();
        this._xid = base.getXid();
        if (base instanceof CreateObjOutputImpl) {
            CreateObjOutputImpl impl = (CreateObjOutputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjOutput) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjOutput)arg).getObjId();
            this._param = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjOutput)arg).getParam();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.CreateObjOutput] \nbut was: " + arg);
        }
    }

    public CreateObjGlobRes getGlobResult() {
        return this._globResult;
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public List<Param> getParam() {
        return this._param;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<CreateObjOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public CreateObjOutputBuilder setGlobResult(CreateObjGlobRes value) {
        this._globResult = value;
        return this;
    }

    public CreateObjOutputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public CreateObjOutputBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    public CreateObjOutputBuilder setParam(List<Param> value) {
        this._param = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public CreateObjOutputBuilder setXid(Long value) {
        if (value != null) {
            CreateObjOutputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public CreateObjOutputBuilder addAugmentation(Class<? extends Augmentation<CreateObjOutput>> augmentationType, Augmentation<CreateObjOutput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CreateObjOutputBuilder removeAugmentation(Class<? extends Augmentation<CreateObjOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CreateObjOutput build() {
        return new CreateObjOutputImpl(this);
    }

    private static final class CreateObjOutputImpl
    implements CreateObjOutput {
        private final CreateObjGlobRes _globResult;
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final List<Param> _param;
        private final Long _xid;
        private Map<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<CreateObjOutput> getImplementedInterface() {
            return CreateObjOutput.class;
        }

        private CreateObjOutputImpl(CreateObjOutputBuilder base) {
            this._globResult = base.getGlobResult();
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._param = base.getParam();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>>(base.augmentation);
                }
            }
        }

        @Override
        public CreateObjGlobRes getGlobResult() {
            return this._globResult;
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public List<Param> getParam() {
            return this._param;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<CreateObjOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._globResult);
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode(this._param);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CreateObjOutput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            CreateObjOutput other = (CreateObjOutput)obj;
            if (!Objects.equals((Object)this._globResult, (Object)other.getGlobResult())) {
                return false;
            }
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals(this._param, other.getParam())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CreateObjOutputImpl otherImpl = (CreateObjOutputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<CreateObjOutput>>, Augmentation<CreateObjOutput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "CreateObjOutput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._globResult != null) {
                builder.append("_globResult=");
                builder.append((Object)this._globResult);
                builder.append(", ");
            }
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._param != null) {
                builder.append("_param=");
                builder.append(this._param);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

