/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultSeverity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.FaultInd;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FaultIndBuilder
implements Builder<FaultInd> {
    private List<String> _affectedObj;
    private String _descr;
    private FaultId _faultId;
    private OcpMsgType _msgType;
    private ObjId _objId;
    private FaultSeverity _severity;
    private FaultState _state;
    private XsdDateTime _timestamp;
    private Long _xid;
    Map<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>> augmentation = Collections.emptyMap();

    public FaultIndBuilder() {
    }

    public FaultIndBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd arg) {
        this._objId = arg.getObjId();
        this._faultId = arg.getFaultId();
        this._state = arg.getState();
        this._severity = arg.getSeverity();
        this._timestamp = arg.getTimestamp();
        this._descr = arg.getDescr();
        this._affectedObj = arg.getAffectedObj();
    }

    public FaultIndBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public FaultIndBuilder(FaultInd base) {
        AugmentationHolder casted;
        this._affectedObj = base.getAffectedObj();
        this._descr = base.getDescr();
        this._faultId = base.getFaultId();
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._severity = base.getSeverity();
        this._state = base.getState();
        this._timestamp = base.getTimestamp();
        this._xid = base.getXid();
        if (base instanceof FaultIndImpl) {
            FaultIndImpl impl = (FaultIndImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getObjId();
            this._faultId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getFaultId();
            this._state = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getState();
            this._severity = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getSeverity();
            this._timestamp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getTimestamp();
            this._descr = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getDescr();
            this._affectedObj = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd)arg).getAffectedObj();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.FaultInd] \nbut was: " + arg);
        }
    }

    public List<String> getAffectedObj() {
        return this._affectedObj;
    }

    public String getDescr() {
        return this._descr;
    }

    public FaultId getFaultId() {
        return this._faultId;
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public FaultSeverity getSeverity() {
        return this._severity;
    }

    public FaultState getState() {
        return this._state;
    }

    public XsdDateTime getTimestamp() {
        return this._timestamp;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<FaultInd>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FaultIndBuilder setAffectedObj(List<String> value) {
        this._affectedObj = value;
        return this;
    }

    public FaultIndBuilder setDescr(String value) {
        this._descr = value;
        return this;
    }

    public FaultIndBuilder setFaultId(FaultId value) {
        this._faultId = value;
        return this;
    }

    public FaultIndBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public FaultIndBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    public FaultIndBuilder setSeverity(FaultSeverity value) {
        this._severity = value;
        return this;
    }

    public FaultIndBuilder setState(FaultState value) {
        this._state = value;
        return this;
    }

    public FaultIndBuilder setTimestamp(XsdDateTime value) {
        this._timestamp = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public FaultIndBuilder setXid(Long value) {
        if (value != null) {
            FaultIndBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public FaultIndBuilder addAugmentation(Class<? extends Augmentation<FaultInd>> augmentationType, Augmentation<FaultInd> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FaultIndBuilder removeAugmentation(Class<? extends Augmentation<FaultInd>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FaultInd build() {
        return new FaultIndImpl(this);
    }

    private static final class FaultIndImpl
    implements FaultInd {
        private final List<String> _affectedObj;
        private final String _descr;
        private final FaultId _faultId;
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final FaultSeverity _severity;
        private final FaultState _state;
        private final XsdDateTime _timestamp;
        private final Long _xid;
        private Map<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FaultInd> getImplementedInterface() {
            return FaultInd.class;
        }

        private FaultIndImpl(FaultIndBuilder base) {
            this._affectedObj = base.getAffectedObj();
            this._descr = base.getDescr();
            this._faultId = base.getFaultId();
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._severity = base.getSeverity();
            this._state = base.getState();
            this._timestamp = base.getTimestamp();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>>(base.augmentation);
                }
            }
        }

        @Override
        public List<String> getAffectedObj() {
            return this._affectedObj;
        }

        @Override
        public String getDescr() {
            return this._descr;
        }

        @Override
        public FaultId getFaultId() {
            return this._faultId;
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public FaultSeverity getSeverity() {
            return this._severity;
        }

        @Override
        public FaultState getState() {
            return this._state;
        }

        @Override
        public XsdDateTime getTimestamp() {
            return this._timestamp;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<FaultInd>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._affectedObj);
            result = 31 * result + Objects.hashCode(this._descr);
            result = 31 * result + Objects.hashCode((Object)this._faultId);
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode((Object)this._severity);
            result = 31 * result + Objects.hashCode((Object)this._state);
            result = 31 * result + Objects.hashCode(this._timestamp);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FaultInd.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FaultInd other = (FaultInd)obj;
            if (!Objects.equals(this._affectedObj, other.getAffectedObj())) {
                return false;
            }
            if (!Objects.equals(this._descr, other.getDescr())) {
                return false;
            }
            if (!Objects.equals((Object)this._faultId, (Object)other.getFaultId())) {
                return false;
            }
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals((Object)this._severity, (Object)other.getSeverity())) {
                return false;
            }
            if (!Objects.equals((Object)this._state, (Object)other.getState())) {
                return false;
            }
            if (!Objects.equals(this._timestamp, other.getTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FaultIndImpl otherImpl = (FaultIndImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FaultInd>>, Augmentation<FaultInd>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FaultInd [";
            StringBuilder builder = new StringBuilder(name);
            if (this._affectedObj != null) {
                builder.append("_affectedObj=");
                builder.append(this._affectedObj);
                builder.append(", ");
            }
            if (this._descr != null) {
                builder.append("_descr=");
                builder.append(this._descr);
                builder.append(", ");
            }
            if (this._faultId != null) {
                builder.append("_faultId=");
                builder.append((Object)this._faultId);
                builder.append(", ");
            }
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._severity != null) {
                builder.append("_severity=");
                builder.append((Object)this._severity);
                builder.append(", ");
            }
            if (this._state != null) {
                builder.append("_state=");
                builder.append((Object)this._state);
                builder.append(", ");
            }
            if (this._timestamp != null) {
                builder.append("_timestamp=");
                builder.append(this._timestamp);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

