/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetParamInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetParamInputBuilder
implements Builder<GetParamInput> {
    private OcpMsgType _msgType;
    private ObjId _objId;
    private String _paramName;
    private Long _xid;
    Map<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>> augmentation = Collections.emptyMap();

    public GetParamInputBuilder() {
    }

    public GetParamInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamInput arg) {
        this._objId = arg.getObjId();
        this._paramName = arg.getParamName();
    }

    public GetParamInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public GetParamInputBuilder(GetParamInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._paramName = base.getParamName();
        this._xid = base.getXid();
        if (base instanceof GetParamInputImpl) {
            GetParamInputImpl impl = (GetParamInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamInput) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamInput)arg).getObjId();
            this._paramName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamInput)arg).getParamName();
            isValidArg = true;
        }
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetParamInput, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public String getParamName() {
        return this._paramName;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetParamInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetParamInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public GetParamInputBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    public GetParamInputBuilder setParamName(String value) {
        this._paramName = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetParamInputBuilder setXid(Long value) {
        if (value != null) {
            GetParamInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetParamInputBuilder addAugmentation(Class<? extends Augmentation<GetParamInput>> augmentationType, Augmentation<GetParamInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetParamInputBuilder removeAugmentation(Class<? extends Augmentation<GetParamInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetParamInput build() {
        return new GetParamInputImpl(this);
    }

    private static final class GetParamInputImpl
    implements GetParamInput {
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final String _paramName;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetParamInput> getImplementedInterface() {
            return GetParamInput.class;
        }

        private GetParamInputImpl(GetParamInputBuilder base) {
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._paramName = base.getParamName();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public String getParamName() {
            return this._paramName;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetParamInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode(this._paramName);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetParamInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetParamInput other = (GetParamInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals(this._paramName, other.getParamName())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetParamInputImpl otherImpl = (GetParamInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetParamInput>>, Augmentation<GetParamInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetParamInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._paramName != null) {
                builder.append("_paramName=");
                builder.append(this._paramName);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

