/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateAllType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.GetStateInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetStateInputBuilder
implements Builder<GetStateInput> {
    private OcpMsgType _msgType;
    private ObjId _objId;
    private StateAllType _stateType;
    private Long _xid;
    private Boolean _eventDrivenReporting;
    Map<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>> augmentation = Collections.emptyMap();

    public GetStateInputBuilder() {
    }

    public GetStateInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput arg) {
        this._objId = arg.getObjId();
        this._stateType = arg.getStateType();
        this._eventDrivenReporting = arg.isEventDrivenReporting();
    }

    public GetStateInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public GetStateInputBuilder(GetStateInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._stateType = base.getStateType();
        this._xid = base.getXid();
        this._eventDrivenReporting = base.isEventDrivenReporting();
        if (base instanceof GetStateInputImpl) {
            GetStateInputImpl impl = (GetStateInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput)arg).getObjId();
            this._stateType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput)arg).getStateType();
            this._eventDrivenReporting = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput)arg).isEventDrivenReporting();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.GetStateInput] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public StateAllType getStateType() {
        return this._stateType;
    }

    public Long getXid() {
        return this._xid;
    }

    public Boolean isEventDrivenReporting() {
        return this._eventDrivenReporting;
    }

    public <E extends Augmentation<GetStateInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetStateInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public GetStateInputBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    public GetStateInputBuilder setStateType(StateAllType value) {
        this._stateType = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public GetStateInputBuilder setXid(Long value) {
        if (value != null) {
            GetStateInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public GetStateInputBuilder setEventDrivenReporting(Boolean value) {
        this._eventDrivenReporting = value;
        return this;
    }

    public GetStateInputBuilder addAugmentation(Class<? extends Augmentation<GetStateInput>> augmentationType, Augmentation<GetStateInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetStateInputBuilder removeAugmentation(Class<? extends Augmentation<GetStateInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public GetStateInput build() {
        return new GetStateInputImpl(this);
    }

    private static final class GetStateInputImpl
    implements GetStateInput {
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final StateAllType _stateType;
        private final Long _xid;
        private final Boolean _eventDrivenReporting;
        private Map<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<GetStateInput> getImplementedInterface() {
            return GetStateInput.class;
        }

        private GetStateInputImpl(GetStateInputBuilder base) {
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._stateType = base.getStateType();
            this._xid = base.getXid();
            this._eventDrivenReporting = base.isEventDrivenReporting();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public StateAllType getStateType() {
            return this._stateType;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        @Override
        public Boolean isEventDrivenReporting() {
            return this._eventDrivenReporting;
        }

        public <E extends Augmentation<GetStateInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode((Object)this._stateType);
            result = 31 * result + Objects.hashCode(this._xid);
            result = 31 * result + Objects.hashCode(this._eventDrivenReporting);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetStateInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetStateInput other = (GetStateInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals((Object)this._stateType, (Object)other.getStateType())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (!Objects.equals(this._eventDrivenReporting, other.isEventDrivenReporting())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GetStateInputImpl otherImpl = (GetStateInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<GetStateInput>>, Augmentation<GetStateInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "GetStateInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._stateType != null) {
                builder.append("_stateType=");
                builder.append((Object)this._stateType);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
                builder.append(", ");
            }
            if (this._eventDrivenReporting != null) {
                builder.append("_eventDrivenReporting=");
                builder.append(this._eventDrivenReporting);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

