/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.HealthCheckInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdUnsignedShort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class HealthCheckInputBuilder
implements Builder<HealthCheckInput> {
    private OcpMsgType _msgType;
    private XsdUnsignedShort _tcpLinkMonTimeout;
    private Long _xid;
    Map<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>> augmentation = Collections.emptyMap();

    public HealthCheckInputBuilder() {
    }

    public HealthCheckInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public HealthCheckInputBuilder(HealthCheckInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._tcpLinkMonTimeout = base.getTcpLinkMonTimeout();
        this._xid = base.getXid();
        if (base instanceof HealthCheckInputImpl) {
            HealthCheckInputImpl impl = (HealthCheckInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public XsdUnsignedShort getTcpLinkMonTimeout() {
        return this._tcpLinkMonTimeout;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<HealthCheckInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public HealthCheckInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public HealthCheckInputBuilder setTcpLinkMonTimeout(XsdUnsignedShort value) {
        this._tcpLinkMonTimeout = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public HealthCheckInputBuilder setXid(Long value) {
        if (value != null) {
            HealthCheckInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public HealthCheckInputBuilder addAugmentation(Class<? extends Augmentation<HealthCheckInput>> augmentationType, Augmentation<HealthCheckInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public HealthCheckInputBuilder removeAugmentation(Class<? extends Augmentation<HealthCheckInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public HealthCheckInput build() {
        return new HealthCheckInputImpl(this);
    }

    private static final class HealthCheckInputImpl
    implements HealthCheckInput {
        private final OcpMsgType _msgType;
        private final XsdUnsignedShort _tcpLinkMonTimeout;
        private final Long _xid;
        private Map<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<HealthCheckInput> getImplementedInterface() {
            return HealthCheckInput.class;
        }

        private HealthCheckInputImpl(HealthCheckInputBuilder base) {
            this._msgType = base.getMsgType();
            this._tcpLinkMonTimeout = base.getTcpLinkMonTimeout();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public XsdUnsignedShort getTcpLinkMonTimeout() {
            return this._tcpLinkMonTimeout;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<HealthCheckInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._tcpLinkMonTimeout);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!HealthCheckInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            HealthCheckInput other = (HealthCheckInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._tcpLinkMonTimeout, other.getTcpLinkMonTimeout())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                HealthCheckInputImpl otherImpl = (HealthCheckInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<HealthCheckInput>>, Augmentation<HealthCheckInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "HealthCheckInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._tcpLinkMonTimeout != null) {
                builder.append("_tcpLinkMonTimeout=");
                builder.append(this._tcpLinkMonTimeout);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

