/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparaminput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyParamInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ModifyParamInputBuilder
implements Builder<ModifyParamInput> {
    private OcpMsgType _msgType;
    private ObjId _objId;
    private List<Param> _param;
    private Long _xid;
    Map<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>> augmentation = Collections.emptyMap();

    public ModifyParamInputBuilder() {
    }

    public ModifyParamInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public ModifyParamInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamInput arg) {
        this._objId = arg.getObjId();
        this._param = arg.getParam();
    }

    public ModifyParamInputBuilder(ModifyParamInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._param = base.getParam();
        this._xid = base.getXid();
        if (base instanceof ModifyParamInputImpl) {
            ModifyParamInputImpl impl = (ModifyParamInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamInput) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamInput)arg).getObjId();
            this._param = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamInput)arg).getParam();
            isValidArg = true;
        }
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyParamInput, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public ObjId getObjId() {
        return this._objId;
    }

    public List<Param> getParam() {
        return this._param;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ModifyParamInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ModifyParamInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public ModifyParamInputBuilder setObjId(ObjId value) {
        this._objId = value;
        return this;
    }

    public ModifyParamInputBuilder setParam(List<Param> value) {
        this._param = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ModifyParamInputBuilder setXid(Long value) {
        if (value != null) {
            ModifyParamInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public ModifyParamInputBuilder addAugmentation(Class<? extends Augmentation<ModifyParamInput>> augmentationType, Augmentation<ModifyParamInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ModifyParamInputBuilder removeAugmentation(Class<? extends Augmentation<ModifyParamInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ModifyParamInput build() {
        return new ModifyParamInputImpl(this);
    }

    private static final class ModifyParamInputImpl
    implements ModifyParamInput {
        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final List<Param> _param;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ModifyParamInput> getImplementedInterface() {
            return ModifyParamInput.class;
        }

        private ModifyParamInputImpl(ModifyParamInputBuilder base) {
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._param = base.getParam();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public ObjId getObjId() {
            return this._objId;
        }

        @Override
        public List<Param> getParam() {
            return this._param;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ModifyParamInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._objId);
            result = 31 * result + Objects.hashCode(this._param);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ModifyParamInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ModifyParamInput other = (ModifyParamInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals(this._param, other.getParam())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ModifyParamInputImpl otherImpl = (ModifyParamInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ModifyParamInput>>, Augmentation<ModifyParamInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ModifyParamInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._objId != null) {
                builder.append("_objId=");
                builder.append(this._objId);
                builder.append(", ");
            }
            if (this._param != null) {
                builder.append("_param=");
                builder.append(this._param);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

