/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.SetTimeInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdDateTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SetTimeInputBuilder
implements Builder<SetTimeInput> {
    private OcpMsgType _msgType;
    private XsdDateTime _newTime;
    private Long _xid;
    Map<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>> augmentation = Collections.emptyMap();

    public SetTimeInputBuilder() {
    }

    public SetTimeInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public SetTimeInputBuilder(SetTimeInput base) {
        AugmentationHolder casted;
        this._msgType = base.getMsgType();
        this._newTime = base.getNewTime();
        this._xid = base.getXid();
        if (base instanceof SetTimeInputImpl) {
            SetTimeInputImpl impl = (SetTimeInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader] \nbut was: " + arg);
        }
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public XsdDateTime getNewTime() {
        return this._newTime;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<SetTimeInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SetTimeInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    public SetTimeInputBuilder setNewTime(XsdDateTime value) {
        this._newTime = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SetTimeInputBuilder setXid(Long value) {
        if (value != null) {
            SetTimeInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public SetTimeInputBuilder addAugmentation(Class<? extends Augmentation<SetTimeInput>> augmentationType, Augmentation<SetTimeInput> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SetTimeInputBuilder removeAugmentation(Class<? extends Augmentation<SetTimeInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SetTimeInput build() {
        return new SetTimeInputImpl(this);
    }

    private static final class SetTimeInputImpl
    implements SetTimeInput {
        private final OcpMsgType _msgType;
        private final XsdDateTime _newTime;
        private final Long _xid;
        private Map<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SetTimeInput> getImplementedInterface() {
            return SetTimeInput.class;
        }

        private SetTimeInputImpl(SetTimeInputBuilder base) {
            this._msgType = base.getMsgType();
            this._newTime = base.getNewTime();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>>(base.augmentation);
                }
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public XsdDateTime getNewTime() {
            return this._newTime;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<SetTimeInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._newTime);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SetTimeInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SetTimeInput other = (SetTimeInput)obj;
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._newTime, other.getNewTime())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SetTimeInputImpl otherImpl = (SetTimeInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SetTimeInput>>, Augmentation<SetTimeInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SetTimeInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._newTime != null) {
                builder.append("_newTime=");
                builder.append(this._newTime);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

