package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.createobjoutput.Param;
import java.util.List;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping createObjOutput {
 *     leaf objId {
 *         type ObjId;
 *     }
 *     list param {
 *         key "name"
 *         leaf name {
 *             type string;
 *         }
 *         leaf result {
 *             type CreateObjRes;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/createObjOutput</i>
 *
 */
public interface CreateObjOutput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "createObjOutput").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>objId</code>, or <code>null</code> if not present
     */
    ObjId getObjId();
    
    /**
     * @return <code>java.util.List</code> <code>param</code>, or <code>null</code> if not present
     */
    List<Param> getParam();

}

