package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;

public enum FaultSeverity {
    FAILED(0, "FAILED"),
    
    DEGRADED(1, "DEGRADED"),
    
    WARNING(2, "WARNING")
    ;

    private static final java.util.Map<java.lang.Integer, FaultSeverity> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, FaultSeverity> b = com.google.common.collect.ImmutableMap.builder();
        for (FaultSeverity enumItem : FaultSeverity.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private FaultSeverity(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding FaultSeverity item
     */
    public static FaultSeverity forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
