package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-types</b>
 * <pre>
 * grouping getStateInput {
 *     leaf objId {
 *         type ObjId;
 *     }
 *     leaf stateType {
 *         type StateAllType;
 *     }
 *     leaf eventDrivenReporting {
 *         type boolean;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-types/getStateInput</i>
 *
 */
public interface GetStateInput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:common:types",
        "2015-08-11", "getStateInput").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId</code> <code>objId</code>, or <code>null</code> if not present
     */
    ObjId getObjId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateAllType</code> <code>stateType</code>, or <code>null</code> if not present
     */
    StateAllType getStateType();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>eventDrivenReporting</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isEventDrivenReporting();

}

