package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;

public enum HealthCheckRes {
    SUCCESS(0, "SUCCESS"),
    
    FAILSYNTAXERROR(1, "FAIL_SYNTAX_ERROR"),
    
    FAILUNRECOGNIZEDMESSAGE(2, "FAIL_UNRECOGNIZED_MESSAGE"),
    
    FAILREBUSY(3, "FAIL_RE_BUSY"),
    
    FAILMISSINGPARAMETER(4, "FAIL_MISSING_PARAMETER"),
    
    FAILPARAMETERERROR(5, "FAIL_PARAMETER_ERROR")
    ;

    private static final java.util.Map<java.lang.Integer, HealthCheckRes> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, HealthCheckRes> b = com.google.common.collect.ImmutableMap.builder();
        for (HealthCheckRes enumItem : HealthCheckRes.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private HealthCheckRes(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding HealthCheckRes item
     */
    public static HealthCheckRes forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
