package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;

public enum StateType {
    AST(0, "AST"),
    
    FST(1, "FST")
    ;

    private static final java.util.Map<java.lang.Integer, StateType> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, StateType> b = com.google.common.collect.ImmutableMap.builder();
        for (StateType enumItem : StateType.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private StateType(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding StateType item
     */
    public static StateType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
