package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.config.rev150811;

public enum KeystoreType {
    /**
     * Keystore type - JKS.
     *
     */
    JKS(0, "JKS"),
    
    /**
     * Keystore type - PKCS12.
     *
     */
    PKCS12(1, "PKCS12")
    ;

    private static final java.util.Map<java.lang.Integer, KeystoreType> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, KeystoreType> b = com.google.common.collect.ImmutableMap.builder();
        for (KeystoreType enumItem : KeystoreType.values()) {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private final java.lang.String name;
    private final int value;

    private KeystoreType(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg integer value
     * @return corresponding KeystoreType item
     */
    public static KeystoreType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
