package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-extension</b>
 * <pre>
 * grouping helloInd {
 *     leaf version {
 *         type string;
 *     }
 *     leaf vendorId {
 *         type string;
 *     }
 *     leaf serialNumber {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-extension/helloInd</i>
 *
 */
public interface HelloInd
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:extension",
        "2015-08-11", "helloInd").intern();

    /**
     * @return <code>java.lang.String</code> <code>version</code>, or <code>null</code> if not present
     */
    java.lang.String getVersion();
    
    /**
     * @return <code>java.lang.String</code> <code>vendorId</code>, or <code>null</code> if not present
     */
    java.lang.String getVendorId();
    
    /**
     * @return <code>java.lang.String</code> <code>serialNumber</code>, or <code>null</code> if not present
     */
    java.lang.String getSerialNumber();

}

