package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for receiving the following YANG notifications defined in module <b>ocp-extension</b>
 * <pre>
 * notification hello-message {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf version {
 *         type string;
 *     }
 *     leaf vendorId {
 *         type string;
 *     }
 *     leaf serialNumber {
 *         type string;
 *     }
 *     uses helloInd;
 *     uses ocpHeader;
 * }
 * </pre>
 *
 */
public interface OcpExtensionListener
    extends
    NotificationListener
{




    void onHelloMessage(HelloMessage notification);

}

