package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>ocp-extension</b>
 * <pre>
 * rpc hello {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type OriHelloAckRes;
 *         }
 *     }
 *     
 *     output {
 *     }
 * }
 * rpc re-direct {
 *     input {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf ip {
 *             type ipv4-address;
 *         }
 *     }
 *     
 *     output {
 *         leaf msgType {
 *             type OcpMsgType;
 *         }
 *         leaf xid {
 *             type uint32;
 *         }
 *         leaf result {
 *             type string;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface OcpExtensionService
    extends
    RpcService
{




    Future<RpcResult<java.lang.Void>> hello(HelloInput input);
    
    Future<RpcResult<ReDirectOutput>> reDirect(ReDirectInput input);

}

