package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-extension</b>
 * <pre>
 * container input {
 *     leaf msgType {
 *         type OcpMsgType;
 *     }
 *     leaf xid {
 *         type uint32;
 *     }
 *     leaf ip {
 *         type ipv4-address;
 *     }
 *     uses redirectInput;
 *     uses ocpHeader;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-extension/re-direct/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInputBuilder
 *
 */
public interface ReDirectInput
    extends
    RedirectInput,
    OcpHeader,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:extension",
        "2015-08-11", "input").intern();


}

