package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>ocp-extension</b>
 * <pre>
 * grouping redirectInput {
 *     leaf ip {
 *         type ipv4-address;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>ocp-extension/redirectInput</i>
 *
 */
public interface RedirectInput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:ocp:extension",
        "2015-08-11", "redirectInput").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address</code> <code>ip</code>, or <code>null</code> if not present
     */
    Ipv4Address getIp();

}

