package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ObjId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateRes;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateVal;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput
 *
 */
public class ModifyStateOutputBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput> {

    private OcpMsgType _msgType;
    private ObjId _objId;
    private ModifyStateRes _result;
    private StateType _stateType;
    private StateVal _stateValue;
    private java.lang.Long _xid;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> augmentation = Collections.emptyMap();

    public ModifyStateOutputBuilder() {
    }
    public ModifyStateOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput arg) {
        this._objId = arg.getObjId();
        this._stateType = arg.getStateType();
        this._stateValue = arg.getStateValue();
    }
    public ModifyStateOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public ModifyStateOutputBuilder(ModifyStateOutput base) {
        this._msgType = base.getMsgType();
        this._objId = base.getObjId();
        this._result = base.getResult();
        this._stateType = base.getStateType();
        this._stateValue = base.getStateValue();
        this._xid = base.getXid();
        if (base instanceof ModifyStateOutputImpl) {
            ModifyStateOutputImpl impl = (ModifyStateOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader) {
            this._msgType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader)arg).getMsgType();
            this._xid = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput) {
            this._objId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput)arg).getObjId();
            this._stateType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput)arg).getStateType();
            this._stateValue = ((org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput)arg).getStateValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.ModifyStateOutput] \n" +
              "but was: " + arg
            );
        }
    }

    public OcpMsgType getMsgType() {
        return _msgType;
    }
    
    public ObjId getObjId() {
        return _objId;
    }
    
    public ModifyStateRes getResult() {
        return _result;
    }
    
    public StateType getStateType() {
        return _stateType;
    }
    
    public StateVal getStateValue() {
        return _stateValue;
    }
    
    public java.lang.Long getXid() {
        return _xid;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ModifyStateOutputBuilder setMsgType(final OcpMsgType value) {
        this._msgType = value;
        return this;
    }
    
     
    public ModifyStateOutputBuilder setObjId(final ObjId value) {
        this._objId = value;
        return this;
    }
    
     
    public ModifyStateOutputBuilder setResult(final ModifyStateRes value) {
        this._result = value;
        return this;
    }
    
     
    public ModifyStateOutputBuilder setStateType(final StateType value) {
        this._stateType = value;
        return this;
    }
    
     
    public ModifyStateOutputBuilder setStateValue(final StateVal value) {
        this._stateValue = value;
        return this;
    }
    
     
     private static void checkXidRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public ModifyStateOutputBuilder setXid(final java.lang.Long value) {
    if (value != null) {
        checkXidRange(value);
    }
        this._xid = value;
        return this;
    }
    
    public ModifyStateOutputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ModifyStateOutputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ModifyStateOutput build() {
        return new ModifyStateOutputImpl(this);
    }

    private static final class ModifyStateOutputImpl implements ModifyStateOutput {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput.class;
        }

        private final OcpMsgType _msgType;
        private final ObjId _objId;
        private final ModifyStateRes _result;
        private final StateType _stateType;
        private final StateVal _stateValue;
        private final java.lang.Long _xid;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> augmentation = Collections.emptyMap();

        private ModifyStateOutputImpl(ModifyStateOutputBuilder base) {
            this._msgType = base.getMsgType();
            this._objId = base.getObjId();
            this._result = base.getResult();
            this._stateType = base.getStateType();
            this._stateValue = base.getStateValue();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public OcpMsgType getMsgType() {
            return _msgType;
        }
        
        @Override
        public ObjId getObjId() {
            return _objId;
        }
        
        @Override
        public ModifyStateRes getResult() {
            return _result;
        }
        
        @Override
        public StateType getStateType() {
            return _stateType;
        }
        
        @Override
        public StateVal getStateValue() {
            return _stateValue;
        }
        
        @Override
        public java.lang.Long getXid() {
            return _xid;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_msgType);
            result = prime * result + Objects.hashCode(_objId);
            result = prime * result + Objects.hashCode(_result);
            result = prime * result + Objects.hashCode(_stateType);
            result = prime * result + Objects.hashCode(_stateValue);
            result = prime * result + Objects.hashCode(_xid);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput)obj;
            if (!Objects.equals(_msgType, other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(_objId, other.getObjId())) {
                return false;
            }
            if (!Objects.equals(_result, other.getResult())) {
                return false;
            }
            if (!Objects.equals(_stateType, other.getStateType())) {
                return false;
            }
            if (!Objects.equals(_stateValue, other.getStateValue())) {
                return false;
            }
            if (!Objects.equals(_xid, other.getXid())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ModifyStateOutputImpl otherImpl = (ModifyStateOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.protocol.rev150811.ModifyStateOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "ModifyStateOutput [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_msgType != null) {
                builder.append("_msgType=");
                builder.append(_msgType);
                builder.append(", ");
            }
            if (_objId != null) {
                builder.append("_objId=");
                builder.append(_objId);
                builder.append(", ");
            }
            if (_result != null) {
                builder.append("_result=");
                builder.append(_result);
                builder.append(", ");
            }
            if (_stateType != null) {
                builder.append("_stateType=");
                builder.append(_stateType);
                builder.append(", ");
            }
            if (_stateValue != null) {
                builder.append("_stateValue=");
                builder.append(_stateValue);
                builder.append(", ");
            }
            if (_xid != null) {
                builder.append("_xid=");
                builder.append(_xid);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
