package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import com.google.common.base.Preconditions;
import java.util.Objects;

/**
 * XSD 16 bit signed integer.
 *
 */
public class XsdShort
 implements Serializable {
    private static final long serialVersionUID = 6009857681716716674L;
    private final java.lang.Short _value;

    private static void check_valueRange(final short value) {
    }

    @ConstructorProperties("value")
    public XsdShort(java.lang.Short _value) {
        if (_value != null) {
            check_valueRange(_value);
            }
    
    
        Preconditions.checkNotNull(_value, "Supplied value may not be null");
    
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public XsdShort(XsdShort source) {
        this._value = source._value;
    }

    public static XsdShort getDefaultInstance(String defaultValue) {
        return new XsdShort(java.lang.Short.valueOf(defaultValue));
    }

    public java.lang.Short getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_value);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        XsdShort other = (XsdShort) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.xsd.types.rev150811.XsdShort.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(_value);
        }
        return builder.append(']').toString();
    }
}

