/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum FaultId {
    FAULTEXTSUPPLYUNDERVOLT(0, "FAULT_EXT_SUPPLY_UNDERVOLT"),
    FAULTREOVERTEMP(1, "FAULT_RE_OVERTEMP"),
    FAULTDIGINOVERDRIVE(2, "FAULT_DIG_IN_OVERDRIVE"),
    FAULTRFOUTOVERDRIVE(3, "FAULT_RF_OUT_OVERDRIVE"),
    FAULTTXGAINFAIL(4, "FAULT_TX_GAIN_FAIL"),
    FAULTRXGAINFAIL(5, "FAULT_RX_GAIN_FAIL"),
    FAULTVSWROUTOFRANGE(6, "FAULT_VSWR_OUTOF_RANGE"),
    FAULTNONAISGTMAMALFCT(7, "FAULT_NON_AISG_TMA_MALFCT"),
    FAULTLINKFAIL(8, "FAULT_LINK_FAIL"),
    FAULTORIPORTFAIL(9, "FAULT_ORI_PORT_FAIL"),
    FAULTORISYNCFAIL(10, "FAULT_ORI_SYNC_FAIL"),
    FAULTAISGMALFCT(11, "FAULT_AISG_MALFCT");

    private static final Map<Integer, FaultId> VALUE_MAP;
    private final String name;
    private final int value;

    private FaultId(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static FaultId forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (FaultId enumItem : FaultId.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

