/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum StateVal {
    LOCKED(0, "LOCKED"),
    UNLOCKED(1, "UNLOCKED"),
    PREOPERATIONAL(2, "PRE_OPERATIONAL"),
    OPERATIONAL(3, "OPERATIONAL"),
    DEGRADED(4, "DEGRADED"),
    FAILED(5, "FAILED"),
    NOTOPERATIONAL(6, "NOT_OPERATIONAL"),
    DISABLED(7, "DISABLED");

    private static final Map<Integer, StateVal> VALUE_MAP;
    private final String name;
    private final int value;

    private StateVal(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static StateVal forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (StateVal enumItem : StateVal.values()) {
            b.put((Object)enumItem.value, (Object)enumItem);
        }
        VALUE_MAP = b.build();
    }
}

