/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.obj;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.StateVal;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.obj.State;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.getstateoutput.obj.StateKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder
implements Builder<State> {
    private StateKey _key;
    private StateType _type;
    private StateVal _value;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(State base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new StateKey(base.getType());
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._type = this._key.getType();
        }
        this._value = base.getValue();
        if (base instanceof StateImpl) {
            StateImpl impl = (StateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(casted.augmentations());
        }
    }

    public StateKey getKey() {
        return this._key;
    }

    public StateType getType() {
        return this._type;
    }

    public StateVal getValue() {
        return this._value;
    }

    public <E extends Augmentation<State>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StateBuilder setKey(StateKey value) {
        this._key = value;
        return this;
    }

    public StateBuilder setType(StateType value) {
        this._type = value;
        return this;
    }

    public StateBuilder setValue(StateVal value) {
        this._value = value;
        return this;
    }

    public StateBuilder addAugmentation(Class<? extends Augmentation<State>> augmentationType, Augmentation<State> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    implements State {
        private final StateKey _key;
        private final StateType _type;
        private final StateVal _value;
        private Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<State> getImplementedInterface() {
            return State.class;
        }

        private StateImpl(StateBuilder base) {
            if (base.getKey() == null) {
                this._key = new StateKey(base.getType());
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._type = this._key.getType();
            }
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<State>>, Augmentation<State>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(base.augmentation);
                }
            }
        }

        @Override
        public StateKey getKey() {
            return this._key;
        }

        @Override
        public StateType getType() {
            return this._type;
        }

        @Override
        public StateVal getValue() {
            return this._value;
        }

        public <E extends Augmentation<State>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode((Object)this._type);
            result = 31 * result + Objects.hashCode((Object)this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!State.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            State other = (State)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals((Object)this._type, (Object)other.getType())) {
                return false;
            }
            if (!Objects.equals((Object)this._value, (Object)other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                StateImpl otherImpl = (StateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<State>>, Augmentation<State>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "State [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append((Object)this._type);
                builder.append(", ");
            }
            if (this._value != null) {
                builder.append("_value=");
                builder.append((Object)this._value);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

