/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparaminput;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparaminput.Param;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.modifyparaminput.ParamKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ParamBuilder
implements Builder<Param> {
    private ParamKey _key;
    private String _name;
    private String _value;
    Map<Class<? extends Augmentation<Param>>, Augmentation<Param>> augmentation = Collections.emptyMap();

    public ParamBuilder() {
    }

    public ParamBuilder(Param base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ParamKey(base.getName());
            this._name = base.getName();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
        }
        this._value = base.getValue();
        if (base instanceof ParamImpl) {
            ParamImpl impl = (ParamImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Param>>, Augmentation<Param>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Param>>, Augmentation<Param>>(casted.augmentations());
        }
    }

    public ParamKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public <E extends Augmentation<Param>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ParamBuilder setKey(ParamKey value) {
        this._key = value;
        return this;
    }

    public ParamBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ParamBuilder setValue(String value) {
        this._value = value;
        return this;
    }

    public ParamBuilder addAugmentation(Class<? extends Augmentation<Param>> augmentationType, Augmentation<Param> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Param>>, Augmentation<Param>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ParamBuilder removeAugmentation(Class<? extends Augmentation<Param>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Param build() {
        return new ParamImpl(this);
    }

    private static final class ParamImpl
    implements Param {
        private final ParamKey _key;
        private final String _name;
        private final String _value;
        private Map<Class<? extends Augmentation<Param>>, Augmentation<Param>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Param> getImplementedInterface() {
            return Param.class;
        }

        private ParamImpl(ParamBuilder base) {
            if (base.getKey() == null) {
                this._key = new ParamKey(base.getName());
                this._name = base.getName();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
            }
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Param>>, Augmentation<Param>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Param>>, Augmentation<Param>>(base.augmentation);
                }
            }
        }

        @Override
        public ParamKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public <E extends Augmentation<Param>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Param.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Param other = (Param)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ParamImpl otherImpl = (ParamImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Param>>, Augmentation<Param>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Param [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._value != null) {
                builder.append("_value=");
                builder.append(this._value);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

