/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpMsgType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.ReDirectInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ReDirectInputBuilder
implements Builder<ReDirectInput> {
    private Ipv4Address _ip;
    private OcpMsgType _msgType;
    private Long _xid;
    Map<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>> augmentation = Collections.emptyMap();

    public ReDirectInputBuilder() {
    }

    public ReDirectInputBuilder(RedirectInput arg) {
        this._ip = arg.getIp();
    }

    public ReDirectInputBuilder(OcpHeader arg) {
        this._msgType = arg.getMsgType();
        this._xid = arg.getXid();
    }

    public ReDirectInputBuilder(ReDirectInput base) {
        AugmentationHolder casted;
        this._ip = base.getIp();
        this._msgType = base.getMsgType();
        this._xid = base.getXid();
        if (base instanceof ReDirectInputImpl) {
            ReDirectInputImpl impl = (ReDirectInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OcpHeader) {
            this._msgType = ((OcpHeader)arg).getMsgType();
            this._xid = ((OcpHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof RedirectInput) {
            this._ip = ((RedirectInput)arg).getIp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.common.types.rev150811.OcpHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.ocp.extension.rev150811.RedirectInput] \nbut was: " + arg);
        }
    }

    public Ipv4Address getIp() {
        return this._ip;
    }

    public OcpMsgType getMsgType() {
        return this._msgType;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ReDirectInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ReDirectInputBuilder setIp(Ipv4Address value) {
        this._ip = value;
        return this;
    }

    public ReDirectInputBuilder setMsgType(OcpMsgType value) {
        this._msgType = value;
        return this;
    }

    private static void checkXidRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ReDirectInputBuilder setXid(Long value) {
        if (value != null) {
            ReDirectInputBuilder.checkXidRange(value);
        }
        this._xid = value;
        return this;
    }

    public ReDirectInputBuilder addAugmentation(Class<? extends Augmentation<ReDirectInput>> augmentationType, Augmentation<ReDirectInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ReDirectInputBuilder removeAugmentation(Class<? extends Augmentation<ReDirectInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ReDirectInput build() {
        return new ReDirectInputImpl(this);
    }

    private static final class ReDirectInputImpl
    implements ReDirectInput {
        private final Ipv4Address _ip;
        private final OcpMsgType _msgType;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ReDirectInput> getImplementedInterface() {
            return ReDirectInput.class;
        }

        private ReDirectInputImpl(ReDirectInputBuilder base) {
            this._ip = base.getIp();
            this._msgType = base.getMsgType();
            this._xid = base.getXid();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getIp() {
            return this._ip;
        }

        @Override
        public OcpMsgType getMsgType() {
            return this._msgType;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ReDirectInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ip);
            result = 31 * result + Objects.hashCode((Object)this._msgType);
            result = 31 * result + Objects.hashCode(this._xid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReDirectInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ReDirectInput other = (ReDirectInput)obj;
            if (!Objects.equals(this._ip, other.getIp())) {
                return false;
            }
            if (!Objects.equals((Object)this._msgType, (Object)other.getMsgType())) {
                return false;
            }
            if (!Objects.equals(this._xid, other.getXid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ReDirectInputImpl otherImpl = (ReDirectInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ReDirectInput>>, Augmentation<ReDirectInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ReDirectInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ip != null) {
                builder.append("_ip=");
                builder.append(this._ip);
                builder.append(", ");
            }
            if (this._msgType != null) {
                builder.append("_msgType=");
                builder.append((Object)this._msgType);
                builder.append(", ");
            }
            if (this._xid != null) {
                builder.append("_xid=");
                builder.append(this._xid);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

